## Installation

### Prerequisites

- Python 3.8+
- PyTorch 1.12+
- CUDA (for GPU acceleration)

### Setup

1.  Navigate to the submission directory:
    ```bash
    cd <submission-directory>
    ```

2.  Install the package and its dependencies:
    ```bash
    pip install -e .
    ```

## Training

### Data Preparation
An example for developing the referring segmentation task is provided. Please refer to the directory `path/to/data_construction`.

### Training Script

```bash
bash path/to/finetune.sh
```

### Serving
First, launch a controller:
/path/to/server/controller.py

Then, launch a model worker and other tool workers:
/path/to/server/model_worker.py, /path/to/server/remotesam_dino_worker.py. If you need to launch a tool worker, you must first prepare the environment for that tool, including its code and weights.

Finally, launch the web server:
/path/to/server/gradio_web_server.py